/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWCorrelationSetPropertiesTableModel;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

abstract class VWCorrelationSetPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
IVWTableActionListener,
ListSelectionListener,
FocusListener {
    protected JTextField m_name = null;
    protected VWToolbarBorder m_propertiesBorder = null;
    protected VWTable m_propertiesTable = null;
    protected VWCorrelationSetPropertiesTableModel m_propertiesTableModel = null;
    protected JTextArea m_sampleMsgTextArea = null;
    protected VWAuthPropertyData m_authPropertyData = null;

    public VWCorrelationSetPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.reinitialize(instructionDef);
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource() == this.m_propertiesBorder) {
                switch (event.getID()) {
                    case 64: {
                        this.onCopy();
                        break;
                    }
                    case 0x10000000: {
                        this.onDelete();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_propertiesTable.getSelectedRow()) {
                    this.m_propertiesTable.clearSelection();
                }
                this.m_propertiesTable.setRowSelectionInterval(nRow, nRow);
            }
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_propertiesTable == null) break;
                this.m_propertiesTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_propertiesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_propertiesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_propertiesTable.getSelectedRow();
            if (this.m_propertiesTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_propertiesTableModel.getRowCount()) - 1) {
                this.m_propertiesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_propertiesBorder.getClientPanel(), 1, Integer.MAX_VALUE));
            }
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (!event.isTemporary() && event.getComponent().equals(this.m_name)) {
            this.onUpdateName();
        }
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 5, 0, 20);
        VWToolbarBorder nameBorder = new VWToolbarBorder(VWResource.s_name);
        JPanel namePanel = nameBorder.getClientPanel();
        namePanel.setLayout(new BorderLayout());
        this.m_name = new JTextField();
        this.m_name.addFocusListener(this);
        namePanel.add(this.m_name);
        this.add((Component)nameBorder, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 1.0;
        this.m_propertiesBorder = new VWToolbarBorder(VWResource.s_properties, 0x10000040);
        this.m_propertiesBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_propertiesBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_propertiesBorder.addToolbarBorderActionNotifier(this);
        JPanel paramPanel = this.m_propertiesBorder.getClientPanel();
        paramPanel.setLayout(new BorderLayout());
        this.m_propertiesTableModel = this.createCorrelationSetPropertiesTableModel();
        this.m_propertiesTableModel.addTableModelListener(this);
        this.m_propertiesTable = new VWTable(this.m_propertiesTableModel);
        this.m_propertiesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_propertiesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_propertiesTable.getSelectionModel().addListSelectionListener(this);
        TableColumn tc = this.m_propertiesTable.getColumnModel().getColumn(0);
        if (tc != null) {
            tc.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        if ((tc = this.m_propertiesTable.getColumnModel().getColumn(1)) != null) {
            tc.setCellEditor(new VWExpressionCellEditor((IVWPropertyData)this.m_authPropertyData, true));
            tc.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        paramPanel.add((Component)new JScrollPane(this.m_propertiesTable), "Center");
        this.add((Component)this.m_propertiesBorder, gbCons);
        ++gbCons.gridx;
        gbCons.gridy = 0;
        gbCons.gridheight = 0;
        gbCons.insets = new Insets(0, 5, 0, 5);
        VWToolbarBorder sampleMsgBorder = new VWToolbarBorder(VWResource.s_sampleMessage);
        JPanel sampleMsgPanel = sampleMsgBorder.getClientPanel();
        sampleMsgPanel.setLayout(new BorderLayout());
        this.m_sampleMsgTextArea = new JTextArea();
        this.m_sampleMsgTextArea.setEditable(false);
        sampleMsgPanel.add((Component)new JScrollPane(this.m_sampleMsgTextArea), "Center");
        this.add((Component)sampleMsgBorder, gbCons);
    }

    protected abstract void onUpdateName();

    protected abstract void reinitialize(VWInstructionDefinition var1);

    protected abstract VWCorrelationSetPropertiesTableModel createCorrelationSetPropertiesTableModel();

    private void onCopy() {
        if (this.m_propertiesTableModel != null) {
            this.m_propertiesTableModel.copy(this.m_propertiesTable.getSelectedRow());
        }
    }

    private void onDelete() {
        if (this.m_propertiesTableModel != null) {
            this.m_propertiesTableModel.delete(this.m_propertiesTable.getSelectedRow());
        }
    }
}

